/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.api.internal.ServerApi;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.function.Supplier;
import loaderCommon.forge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.forge.com.seibel.distanthorizons.common.util.ProxyUtil;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Logger;

public class ForgeServerProxy
implements AbstractModInitializer.IEventProxy {
    private final ServerApi serverApi = ServerApi.INSTANCE;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final boolean isDedicated;
    public static Supplier<Boolean> isGenerationThreadChecker = null;

    private static LevelAccessor GetEventLevel(LevelEvent e) {
        return e.getLevel();
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ForgeServerProxy(boolean isDedicated) {
        this.isDedicated = isDedicated;
        isGenerationThreadChecker = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.serverApi.serverTickEvent();
        }
    }

    @SubscribeEvent
    public void dedicatedWorldLoadEvent(ServerAboutToStartEvent event) {
        this.serverApi.serverLoadEvent(this.isDedicated);
    }

    @SubscribeEvent
    public void serverWorldUnloadEvent(ServerStoppingEvent event) {
        this.serverApi.serverUnloadEvent();
    }

    @SubscribeEvent
    public void serverLevelLoadEvent(LevelEvent.Load event) {
        if (ForgeServerProxy.GetEventLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelLoadEvent(ForgeServerProxy.getServerLevelWrapper((ServerLevel)ForgeServerProxy.GetEventLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverLevelUnloadEvent(LevelEvent.Unload event) {
        if (ForgeServerProxy.GetEventLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelUnloadEvent(ForgeServerProxy.getServerLevelWrapper((ServerLevel)ForgeServerProxy.GetEventLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverChunkLoadEvent(ChunkEvent.Load event) {
        ILevelWrapper levelWrapper = ProxyUtil.getLevelWrapper(ForgeServerProxy.GetEventLevel((LevelEvent)event));
        ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeServerProxy.GetEventLevel((LevelEvent)event), levelWrapper);
        this.serverApi.serverChunkLoadEvent(chunk, levelWrapper);
    }

    private static ServerLevelWrapper getServerLevelWrapper(ServerLevel level) {
        return ServerLevelWrapper.getWrapper(level);
    }
}

